<?php
/*--------------------------------------------------------------
   TableColumns.php 2021-05-31
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\Collections;

use ArrayIterator;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Column;
use InvalidArgumentException;
use IteratorAggregate;
use Webmozart\Assert\Assert;

class TableColumns implements IteratorAggregate
{
    /**
     * @var Column[]
     */
    private $values;
    
    
    /**
     * Constructor.
     */
    private function __construct(array $values)
    {
        $this->values = $values;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Column ...$columns): self
    {
        return new self($columns);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): ArrayIterator
    {
        return new ArrayIterator($this->values);
    }
    
    
    /**
     * Return column by field.
     */
    public function getByField(string $field): Column
    {
        Assert::stringNotEmpty($field);
        
        /**
         * @var Column $column
         */
        foreach ($this->values as $column) {
            if ($field === $column->field()) {
                return $column;
            }
        }
        
        throw new InvalidArgumentException("Column not found");
    }
}